/***************************************************************************
 *   Copyright (C) 2006-2018 by Oleksandr Shneyder                         *
 *   o.shneyder@phoca-gmbh.de                                              *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include <QApplication>
#include <QTranslator>
#include <QLocale>
#include "sharetray.h"
#include <QLocalSocket>
#include <iostream>
#include <QDir>
#include <csignal>

using namespace std;

void  client ( const QStringList & cmd )
{

	if ( cmd.size() !=11 )
	{
		cerr<<"wrong parameters"<<endl;
		cout<<"DENY";
		return;
	}
	QStringList params=cmd[9].split ( "XSHAD" );
	if ( params.size() !=3 )
	{
		cerr<<"wrong parameters"<<endl;
		cout<<"DENY";
		return;
	}

	cerr<<"starting x2godesktopsharing in client mode, cmd: "<<
	cmd.join(" ").toLatin1().data() <<std::endl;

	QString dispname=params[2];
	// QString socketName=QDir::tempPath() +"/x2godesktopsharing_@"+
	//                   params[1]+"@"+dispname;
	QString socketName="/tmp/x2godesktopsharing_@" + params[1]+"@"+dispname;
	QLocalSocket sock;
	sock.connectToServer ( socketName );
	if ( !sock.waitForConnected ( 3000 ) )
	{
		QString message="Unable to connect: " +socketName;
		cout<<"DENY";
		cerr<<message.toLatin1().data() <<endl;
		return;
	}
	sock.write ( cmd.join(" ").toLatin1().data(),cmd.join(" ").toLatin1().length() );
	if ( !sock.waitForReadyRead() )
	{
		cout<<"DENY";
		cerr<<"Cannot write to socket: "<<socketName.toLatin1().data() <<endl;
		return;;
	}
	char buffer[256];
	int read=sock.read ( buffer,255 );
	if ( read<=0 )
	{
		cout<<"DENY";
		cerr<<"Cannot read from socket: " <<socketName.toLatin1().data() <<endl;
		return;
	}
	buffer[read]=0;
	cout<<buffer<<endl;
}

static int setup_unix_signal_handlers()
{
	struct sigaction keybint, term, abort, hup;

	keybint.sa_handler = ShareTray::keybintSignalHandler;
	sigemptyset(&keybint.sa_mask);
	keybint.sa_flags = 0;
	keybint.sa_flags |= SA_RESTART;

	if (sigaction(SIGINT, &keybint, 0) > 0)
		return 1;

	term.sa_handler = ShareTray::termSignalHandler;
	sigemptyset(&term.sa_mask);
	term.sa_flags |= SA_RESTART;

	if (sigaction(SIGTERM, &term, 0) > 0)
	return 2;

	abort.sa_handler = ShareTray::abortSignalHandler;
	sigemptyset(&abort.sa_mask);
	abort.sa_flags |= SA_RESTART;

	if (sigaction(SIGABRT, &abort, 0) > 0)
	return 3;

	hup.sa_handler = ShareTray::hupSignalHandler;
	sigemptyset(&hup.sa_mask);
	hup.sa_flags |= SA_RESTART;

	if (sigaction(SIGHUP, &hup, 0) > 0)
	return 4;

	return 0;
}

int main ( int argc, char *argv[] )
{
	if ( argc>2 )
	{
		QString par=argv[1];
		if ( par == "client" )
		{
			QStringList cmdl;
			for ( int i=2; i<argc;++i )
			cmdl<<argv[i];
			client ( cmdl );
			return 0;
		}
	}

	QApplication app ( argc,argv );
	QStringList args=QCoreApplication::arguments();

	QTranslator translator;
	QString filename=QString ( ":/x2godesktopsharing_%1" ).arg (
	                 QLocale::system().name() );
	filename=filename.toLower();
	if ( !translator.load ( filename ) )
	{
		qDebug ( "Can't load translator (%s) !\n",
		         filename.toLocal8Bit().data() );
	}
	else
		app.installTranslator ( &translator );

	QTranslator qtTranslator;
	filename=QString ( ":/qt_%1" ).arg ( QLocale::system().name() );
	if ( !qtTranslator.load ( filename ) )
	{
		qDebug ( "Can't load translator (%s) !\n",
		         filename.toLocal8Bit().data() );
	}
	else
		app.installTranslator ( &qtTranslator );

	ShareTray* tray=new ShareTray;
	tray->hide();
	setup_unix_signal_handlers();
	try {
		return app.exec();
	} catch (const std::bad_alloc &) {
		tray->slotMenuClose();
	}
}
