
## Game compatibility testing

It is important to ensure that any proposed change does not break game compatibility 
(unless this has been previously agreed upon).  The following sections describe the tests that should be 
run to ensure game compatibility between a previously-released version (referred to below as **OLD**) and a 
branch containing a proposed change (referred to below as **NEW**).

### Save games

Ensure compatibility between save games generated by different versions.

##### Save game generated by NEW should be readable by OLD

1. Save game using NEW.
1. Load save game from (1) using OLD.

##### Save game generated by OLD should be readable by NEW

1. Save game using OLD.
1. Load save game from (1) using NEW.

### Network games

Ensure compatibility between network nodes running different versions.

##### Server running NEW should be able to communicate with client running OLD

1. Host a local network game using NEW.
1. Connect to game started in (1) using OLD.
    * Ensure OLD and NEW select players in adversarial roles.
1. Progress far enough in the game to fight a battle.

##### Lobby and bot running OLD should be able to communicate with client running NEW

1. Run a lobby with at least one bot using OLD.
    * This can be done locally or you can use the production lobby if a bot is available.
1. Connect to lobby started in (1) using NEW and start a game with bot.
    * Ensure OLD and NEW select players in adversarial roles.
1. Progress far enough in the game to fight a battle.



## Manual Regression Testing

- Various maps can be opened, no delegates brokens
- Launch an AI only game and let some AI players go at for a dozen rounds, verify no errors.
- Join a lobby bot of live lobby, play through a combat (compatability check). 
- Verify important combat rules are working (can be combined with above step)
- More Compatibility checks
  - save games
  - network play
  - XML parsing
  
- Local host + client
  - This means start up two copies of triplea.  In one copy you click ‘host networked game’ 
and start hosting.  In the other copy you click ‘connect to networked game’ and join.  The client should choose the 
FIRST player in the list (this is to test that the delegates are sending data correctly).  
Start the game and play a round against yourself, making sure everything looks good.  

- Play by Email, and Play by Forum  
  - You can test both at once by setting up a game against yourself that has both settings enabled.  
  You will probably need to add two email addresses for this to work. 
  - Test all forums
  - Recommend test play by email with both a gmail and a hotmail account.  
