/*
 * Copyright 2000-2014 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.usages.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.usages.UsageView;
import com.intellij.usages.impl.UsageViewImpl;
import org.jetbrains.annotations.NotNull;

/**
* @author gregsh
*/
public class RerunSearchAction extends DumbAwareAction {

  @Override
  public void actionPerformed(@NotNull AnActionEvent e) {
    UsageView usageView = UsageView.USAGE_VIEW_KEY.getData(e.getDataContext());
    if (usageView instanceof UsageViewImpl) {
      ((UsageViewImpl)usageView).refreshUsages();
    }
  }

  @Override
  public void update(@NotNull AnActionEvent e) {
    UsageView usageView = UsageView.USAGE_VIEW_KEY.getData(e.getDataContext());
    boolean enabled = usageView instanceof UsageViewImpl && ((UsageViewImpl)usageView).canPerformReRun();
    e.getPresentation().setEnabled(enabled);
  }
}
