/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * Information about an external data source in the spreadsheet.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DataSource extends com.google.api.client.json.GenericJson {

  /**
   * All calculated columns in the data source.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<DataSourceColumn> calculatedColumns;

  /**
   * The spreadsheet-scoped unique ID that identifies the data source. Example: 1080547365.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String dataSourceId;

  /**
   * The ID of the Sheet connected with the data source. The field cannot be changed once set. When
   * creating a data source, an associated DATA_SOURCE sheet is also created, if the field is not
   * specified, the ID of the created sheet will be randomly generated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer sheetId;

  /**
   * The DataSourceSpec for the data source connected with this spreadsheet.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DataSourceSpec spec;

  /**
   * All calculated columns in the data source.
   * @return value or {@code null} for none
   */
  public java.util.List<DataSourceColumn> getCalculatedColumns() {
    return calculatedColumns;
  }

  /**
   * All calculated columns in the data source.
   * @param calculatedColumns calculatedColumns or {@code null} for none
   */
  public DataSource setCalculatedColumns(java.util.List<DataSourceColumn> calculatedColumns) {
    this.calculatedColumns = calculatedColumns;
    return this;
  }

  /**
   * The spreadsheet-scoped unique ID that identifies the data source. Example: 1080547365.
   * @return value or {@code null} for none
   */
  public java.lang.String getDataSourceId() {
    return dataSourceId;
  }

  /**
   * The spreadsheet-scoped unique ID that identifies the data source. Example: 1080547365.
   * @param dataSourceId dataSourceId or {@code null} for none
   */
  public DataSource setDataSourceId(java.lang.String dataSourceId) {
    this.dataSourceId = dataSourceId;
    return this;
  }

  /**
   * The ID of the Sheet connected with the data source. The field cannot be changed once set. When
   * creating a data source, an associated DATA_SOURCE sheet is also created, if the field is not
   * specified, the ID of the created sheet will be randomly generated.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getSheetId() {
    return sheetId;
  }

  /**
   * The ID of the Sheet connected with the data source. The field cannot be changed once set. When
   * creating a data source, an associated DATA_SOURCE sheet is also created, if the field is not
   * specified, the ID of the created sheet will be randomly generated.
   * @param sheetId sheetId or {@code null} for none
   */
  public DataSource setSheetId(java.lang.Integer sheetId) {
    this.sheetId = sheetId;
    return this;
  }

  /**
   * The DataSourceSpec for the data source connected with this spreadsheet.
   * @return value or {@code null} for none
   */
  public DataSourceSpec getSpec() {
    return spec;
  }

  /**
   * The DataSourceSpec for the data source connected with this spreadsheet.
   * @param spec spec or {@code null} for none
   */
  public DataSource setSpec(DataSourceSpec spec) {
    this.spec = spec;
    return this;
  }

  @Override
  public DataSource set(String fieldName, Object value) {
    return (DataSource) super.set(fieldName, value);
  }

  @Override
  public DataSource clone() {
    return (DataSource) super.clone();
  }

}
