# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.


### These strings are used inside the Storage Inspector.

# Key shortcut used to focus the filter box on top of the data view
storage-filter-key = CmdOrCtrl+F

# Hint shown when the selected storage host does not contain any data
storage-table-empty-text = ᱵᱟᱪᱷᱟᱣ ᱟᱠᱟᱱ ᱦᱚᱥᱴ ᱞᱟᱹᱜᱤᱫ ᱡᱟᱦᱟᱸᱱ ᱰᱮᱴᱟ ᱵᱟᱹᱱᱩᱜᱼᱟ

# Hint shown when the cookies storage type is selected. Clicking the link will open
# https://firefox-source-docs.mozilla.org/devtools-user/storage_inspector/cookies/
storage-table-type-cookies-hint = ᱦᱚᱥᱴ ᱵᱟᱪᱷᱟᱣ ᱠᱟᱛᱮ ᱠᱩᱠᱤᱡᱽ ᱧᱮᱞ ᱟᱨ ᱥᱟᱯᱲᱟᱣ ᱢᱮ᱾ <a data-l10n-name="learn-more-link">ᱵᱟᱹᱲᱛᱤ ᱵᱟᱰᱟᱭ ᱢᱮ</a>

# Hint shown when the local storage type is selected. Clicking the link will open
# https://firefox-source-docs.mozilla.org/devtools-user/storage_inspector/local_storage_session_storage/
storage-table-type-localstorage-hint = ᱢᱤᱫ ᱦᱚᱥᱴ ᱵᱟᱪᱷᱟᱣ ᱠᱟᱛᱮ ᱞᱚᱠᱟᱞ ᱥᱴᱚᱨᱮᱡᱽ ᱧᱮᱞ ᱟᱨ ᱥᱟᱯᱲᱟᱣ ᱢᱮ᱾ <a data-l10n-name="learn-more-link">ᱵᱟᱹᱲᱛᱤ ᱵᱟᱰᱟᱭ ᱢᱮ</a>

# Hint shown when the session storage type is selected. Clicking the link will open
# https://firefox-source-docs.mozilla.org/devtools-user/storage_inspector/local_storage_session_storage/
storage-table-type-sessionstorage-hint = ᱢᱤᱫ ᱦᱚᱥᱴ ᱵᱟᱪᱷᱟᱣ ᱠᱟᱛᱮ ᱥᱮᱥᱚᱱ ᱥᱴᱚᱨᱮᱡᱽ ᱧᱮᱞ ᱟᱨ ᱥᱟᱯᱲᱟᱣ ᱢᱮ᱾ <a data-l10n-name="learn-more-link">ᱵᱟᱹᱲᱛᱤ ᱵᱟᱰᱟᱭ ᱢᱮ</a>

# Hint shown when the IndexedDB storage type is selected. Clicking the link will open
# https://firefox-source-docs.mozilla.org/devtools-user/storage_inspector/indexeddb/
storage-table-type-indexeddb-hint = ᱢᱤᱫ ᱰᱮᱴᱟᱵᱮᱥ ᱵᱟᱪᱷᱟᱣ ᱠᱟᱛᱮ IndexedDB ᱟᱫᱮᱨ ᱟᱠᱟᱱᱟᱜ ᱠᱚ ᱧᱮᱞ ᱟᱨ ᱜᱮᱫ ᱜᱤᱰᱤ ᱢᱮ᱾<a data-l10n-name="learn-more-link">ᱵᱟᱹᱲᱛᱤ ᱵᱟᱰᱟᱭ ᱢᱮ᱾</a>

# Hint shown when the cache storage type is selected. Clicking the link will open
# https://firefox-source-docs.mozilla.org/devtools-user/storage_inspector/cache_storage/
storage-table-type-cache-hint = ᱢᱤᱫ ᱥᱴᱚᱨᱮᱡᱽ ᱵᱟᱪᱷᱟᱣ ᱠᱟᱛᱮ ᱠᱮᱪ ᱥᱴᱚᱨᱮᱡᱽ ᱧᱮᱞ ᱟᱨ ᱜᱮᱫ ᱜᱤᱰᱤ ᱢᱮ᱾ <a data-l10n-name="learn-more-link">ᱵᱟᱹᱲᱛᱤ ᱵᱟᱰᱟᱭ ᱢᱮ᱾</a>

# Hint shown when the extension storage type is selected. Clicking the link will open
# https://firefox-source-docs.mozilla.org/devtools-user/storage_inspector/extension_storage/
storage-table-type-extensionstorage-hint = ᱢᱤᱫ ᱦᱚᱥᱴ ᱵᱟᱪᱷᱟᱣ ᱠᱟᱛᱮ ᱮᱠᱥᱴᱮᱱᱥᱚᱱ ᱥᱴᱚᱨᱮᱡᱽ ᱧᱮᱞ ᱟᱨ ᱥᱟᱯᱲᱟᱣ ᱢᱮ᱾ <a data-l10n-name="learn-more-link">ᱵᱟᱹᱲᱛᱤ ᱵᱟᱰᱟᱭ ᱢᱮ᱾</a>

# Placeholder for the searchbox that allows you to filter the table items
storage-search-box =
    .placeholder = ᱞᱤᱥᱴᱤ ᱪᱷᱟᱹᱱᱤ ᱢᱮ

# Placeholder text in the sidebar search box
storage-variable-view-search-box =
    .placeholder = ᱜᱚᱱᱚᱝ ᱪᱷᱟᱹᱱᱤ ᱢᱮ

# Add Item button title
storage-add-button =
    .title = ᱞᱤᱥᱴᱤ ᱥᱮᱞᱮᱫᱽ ᱢᱮ

# Refresh button title
storage-refresh-button =
    .title = ᱞᱤᱥᱴᱤ ᱯᱷᱟᱹᱨᱭᱟᱹᱣ ᱢᱮ

# Context menu action to delete all storage items
storage-context-menu-delete-all =
    .label = ᱡᱚᱛᱚ ᱢᱮᱴᱟᱣ ᱢᱮ

# Context menu action to delete all session cookies
storage-context-menu-delete-all-session-cookies =
    .label = ᱡᱚᱛᱚ ᱥᱮᱥᱚᱱᱥ ᱠᱩᱠᱤᱡᱽ ᱢᱮᱴᱟᱣ ᱢᱮ

# Context menu action to copy a storage item
storage-context-menu-copy =
    .label = ᱱᱚᱠᱚᱞ

# Context menu action to delete storage item
# Variables:
#   $itemName (String) - Name of the storage item that will be deleted
storage-context-menu-delete =
    .label = { $itemName } ᱢᱮᱴᱟᱣ ᱢᱮ

# Context menu action to add an item
storage-context-menu-add-item =
    .label = ᱞᱤᱥᱴᱤ ᱥᱮᱞᱮᱫᱽ ᱢᱮ

# Context menu action to delete all storage items from a given host
# Variables:
#   $host (String) - Host for which we want to delete the items
storage-context-menu-delete-all-from =
    .label = { $host } ᱡᱚᱛᱚ ᱯᱷᱚᱨᱢ ᱢᱮᱴᱟᱣ ᱢᱮ

## Header names of the columns in the Storage Table for each type of storage available
## through the Storage Tree to the side.

storage-table-headers-cookies-name = ᱧᱩᱛᱩᱢ
storage-table-headers-cookies-value = ᱜᱚᱱᱚᱝ
storage-table-headers-cookies-expires = ᱪᱟᱵᱟᱜᱼᱟ / ᱵᱟᱹᱲᱛᱤ ᱩᱢᱮᱨ
storage-table-headers-cookies-size = ᱢᱟᱯ
storage-table-headers-cookies-last-accessed = ᱢᱟᱲᱟᱝ ᱟᱫᱮᱨᱟᱜ
storage-table-headers-cookies-creation-time = ᱛᱮᱭᱟᱨ ᱮᱱᱟ
storage-table-headers-cache-status = ᱫᱚᱥᱟ
storage-table-headers-extension-storage-area = ᱵᱟᱺᱫᱤ ᱮᱨᱤᱭᱟ

## Labels for Storage type groups present in the Storage Tree, like cookies, local storage etc.

storage-tree-labels-cookies = ᱠᱩᱠᱤᱡᱽᱠᱚ
storage-tree-labels-local-storage = ᱞᱚᱠᱟᱞ ᱵᱟᱺᱫᱤ
storage-tree-labels-session-storage = ᱥᱮᱥᱚᱱ ᱵᱟᱺᱫᱤ
storage-tree-labels-indexed-db = ᱤᱱᱰᱮᱠᱥ ᱟᱠᱟᱱᱟᱜ ᱰᱮᱴᱟᱵᱮᱥ
storage-tree-labels-cache = ᱠᱮᱪ ᱵᱟᱺᱫᱤ
storage-tree-labels-extension-storage = ᱮᱠᱥᱴᱮᱱᱥᱚᱱ ᱵᱟᱺᱫᱤ

##

# Tooltip for the button that collapses the right panel in the
# storage UI when the panel is closed.
storage-expand-pane =
    .title = ᱯᱷᱚᱞᱚᱠ ᱯᱟᱥᱱᱟᱣ ᱢᱮ

# Tooltip for the button that collapses the right panel in the
# storage UI when the panel is open.
storage-collapse-pane =
    .title = ᱯᱷᱚᱞᱚᱠ ᱥᱟᱢᱴᱟᱣ ᱢᱮ

# String displayed in the expires column when the cookie is a Session Cookie
storage-expires-session = ᱥᱮᱥᱚᱱ

# Heading displayed over the item value in the sidebar
storage-data = ᱰᱟᱴᱟ

# Heading displayed over the item parsed value in the sidebar
storage-parsed-value = ᱟᱹᱜᱩ ᱟᱠᱟᱱ ᱜᱚᱱᱚᱝ

# Warning notification when IndexedDB database could not be deleted immediately.
# Variables:
#   $dbName (String) - Name of the database
storage-idb-delete-blocked = { $dbName } ᱰᱮᱴᱟᱵᱮᱥ ᱫᱚ ᱢᱮᱴᱟᱣᱜᱼᱟ ᱡᱚᱛᱚ ᱛᱚᱯᱚᱞ ᱵᱚᱱᱫᱚ ᱮᱱ ᱛᱟᱭᱚᱢ᱾

# Error notification when IndexedDB database could not be deleted.
# Variables:
#   $dbName (String) - Name of the database
storage-idb-delete-error = { $dbName } ᱰᱮᱴᱟᱵᱮᱥ ᱫᱚ ᱵᱟᱭ ᱢᱮᱴᱟᱣᱜᱼᱟ᱾
