@rem = '--*-Perl-*--
@echo off
if "%OS%" == "Windows_NT" goto WinNT
perl -x -S "%0" %1 %2 %3 %4 %5 %6 %7 %8 %9
goto endofperl
:WinNT
perl -x -S %0 %*
if NOT "%COMSPEC%" == "%SystemRoot%\system32\cmd.exe" goto endofperl
if %errorlevel% == 9009 echo You do not have Perl in your PATH.
if errorlevel 1 goto script_failed_so_exit_with_non_zero_val 2>nul
goto endofperl
@rem ';
#!/usr/bin/perl -w
#line 15
#
# ecaccess-ectrans-delete: Delete ECtrans
#
# Laurent.Gougeon@ecmwf.int - 2010-10-15

use ECMWF::ECaccess;
use Getopt::Long;
use Pod::Usage;

my %opt = (
	version => 0,
	help    => 0,
	manual  => 0,
	retry	=> 0,
	debug   => 0
);

pod2usage( -noperldoc => 1, -exit => 1, verbose => 1 ) if !GetOptions(
	\%opt,
	qw(
	  version
	  help|?
	  manual
	  retry=i
	  debug
	  )
);

# Display version if requested
die ECMWF::ECaccess->VERSION . "\n" if ( $opt{version} );

my $ectransId = $ARGV[0];

pod2usage( -noperldoc => 1, -exit => 1, verbose => 1 ) if ( $opt{help} );
pod2usage( -noperldoc => 1, -exit => 1, verbose => 2 ) if ( $opt{manual} );
pod2usage( -noperldoc => 1, -exit => 1, verbose => 0, -msg => "No ectrans-id specified!\n" ) if not($ectransId);

# Create the ECaccess Controler
my $ecaccess = ECMWF::ECaccess->new( $opt{retry}, $opt{debug});

# Get the Token (using the Certificate in $HOME)
my $token = $ecaccess->getToken();

# Get the Control Channel
my $controlChannel = $ecaccess->getControlChannel();

# Delete the ectrans
$controlChannel->deleteTransfer( $token, $ectransId );

# Logout
$ecaccess->releaseToken($token);

__END__

=head1 NAME

ecaccess-ectrans-delete - Delete ECtrans

=head1 SYNOPSIS

B<ecaccess-ectrans-delete -version|-help|-manual>

B<ecaccess-ectrans-delete [-debug]> I<ectrans-id>

=head1 DESCRIPTION

Allow deleting the ECtrans transfer with the I<ectrans-id> identifier from the ECtrans Spool.

=head1 ARGUMENTS

=over 8

=item I<ectrans-id>

The identifier of the ECtrans transfer to delete.

=back

=head1 OPTIONS

=over 8

=item B<-version>

Display version number and exits.

=item B<-help>

Print a brief help message and exits.

=item B<-manual>

Prints the manual page and exits.

=item B<-retry> I<count>

Number of SSL connection retries per 5s to ECMWF. This parameter only apply to the
initial SSL connection initiated by the command to the ECMWF server. It does not
apply to all the subsequent requests made afteward as it is mainly targeting errors
that can happen from time to time during the SSL handshake. Default is no retry.

=item B<-debug>

Display the SOAP and SSL messages exchanged.

=back

=head1 EXAMPLES

B<ecaccess-ectrans-delete> I<124356>

Delete the ECtrans transfer with the identifier I<124356>.

=head1 SEE ALSO

B<ecaccess-ectrans-list>, B<ecaccess-ectrans-request>, B<ecaccess-ectrans-restart> and B<ecaccess>.

=cut

__END__
:endofperl
