
Notable changes in 0.33 since 0.32
==================================

* Python 3 is now required, in particular 3.7 or newer.

* The version of Python is no longer determined by the value of
  `PYTHON` during `./configure`.  It is now determined by the version
  of `python-config` selected during configuration.  The
  `BUP_PYTHON_CONFIG` environment variable can be set during
  configuration to select a particular executable
  (e.g. `BUP_PYTHON_CONFIG=python3.9-config ./configure`).  See the
  `README` for further details.

* The `bup` executable is now a binary rather than a Python script.
  Practically speaking, this means that the Python version is
  determined by the `libpython` that the executable is linked against
  (selected via `python-config`), and it means that bup will show up
  as "bup" in process listings rather than a python invocation.

* The output of `bup ls` for multiple paths includes each path before
  its contents, more closely matching the system `ls`.

* The `bup ftp` `ls` command should now respect the working directory
  (set by `cd`), and that directory has been added to the prompt.

* Some minor changes have been made to `bup web`'s interface.

* The `index-cache` is no longer included in the `bup midx` `--dir`
  default.

* Performance may have improved after the relocation of a number of
  operations from Python to C, and a number of improvements to the
  VFS.

* The `#bup` IRC channel has moved to https://libera.chat/.

Bugs
----

* Bup should now respect the current umask, directory sgid bit,
  etc. when creating new files (e.g. new packfiles).  Previously, it
  would create them via mkstemp, which would cause them to be readable
  only by the current user.

* Bup should now be able to handle repositories containing signed
  commits.

* `bup tag` has been changed to rely on `git update-ref` instead of
  writing the (loose) refs directly so that it can handle packed refs
  correctly.

* `bup save` should be more careful about noting an error and skipping
  paths whose type (link, regular file, ...) has changed since
  indexing.

* There should no longer be a narrow window where `save` could store
  conflicting symlink targets or conflicting sizes (in the metadata
  record and the packfile symlink blob) for a path if the filesystem
  changed at just the wrong time during a save.

* `bup fuse` should no longer become unusable after an unfinished read
  of commits associated with tags.  The underlying VFS issue may have
  affected other commands too.

* Bup's packfile names should now match git's.  Previously bup
  computed the SHA1 from just the sorted object list
  (cf. `git-index-pack(1)`), but git appears to include the entire
  pack file in the hash.

* Passing idx files to `bup midx` along with `--dir` should now work
  correctly.

* The `bup index --print --long ...` mode fields should now be
  formatted correctly with Python 3 (it changed the `oct()` format).

* Resource usage (e.g. memory) may have improved, given a number of
  changes intended to make bup release resources more carefully and
  sooner.

Build and install
-----------------

* As mentioned above, `PYTHON`'s role during configuration has been
  replaced by `BUP_PYTHON_CONFIG`.

* `./configure` now supports `--with-pylint=[yes|no|maybe]`.

* Any `CC`, `CPPFLAGS`, `CFLAGS`, or `LDFLAGS` set during
  `./configure` should now be preserved across future make
  invocations.

* The build process should now work on systems where `make` isn't GNU
  Make (the `Makefile` automatically redirects to `GNUmakefile`).

* The `PANDOC` path can contain spaces.

Thanks to (at least)
====================

Abdel Said, Arthur Ward, Bas Stottelaar, Brian Minton, Greg Troxel,
Johannes Berg, Mark Hewitt, Muh Muhten, and Rob Browning
